<?php

namespace App\Enums;

use App\Helpers\ModuleMetaData;

enum AdminGetRoutesEnum
{
    public static function landlordAdminRoutes():  array
    {
        $generalRoutes = [
            'landlord.admin.home' => 'dashboard',
            'landlord.admin.health' => 'site health',
            'landlord.admin.change.password' => 'change password',
            'landlord.admin.pages' => 'all pages',
            'landlord.admin.pages.create' => 'create page',
            'landlord.admin.theme' => 'all theme',
            'landlord.admin.theme.settings' => 'theme settings',
            'landlord.admin.price.plan' => 'all price plan',
            'landlord.admin.price.plan.create' => 'create price plan',
            'landlord.admin.price.plan.settings' => 'price plan settings',
            'landlord.admin.tenant.website.issues' => 'website issues',
            'landlord.admin.support.ticket.all' => 'all tickets',
            'landlord.admin.support.ticket.new' => 'new ticket',
            'landlord.admin.support.ticket.page.settings' => 'page settings',
            'landlord.admin.support.ticket.department' => 'ticket department',
            'landlord.admin.testimonial' => 'testimonial',
            'landlord.admin.brands' => 'brands',
            'landlord.admin.contact.message.all' => 'all messages',
            'landlord.admin.widgets' => 'widgets',
            'landlord.admin.highlight' => 'highlight settings',
            'landlord.admin.breadcrumb' => 'breadcrumb settings',
            'landlord.admin.form.builder.all' => 'all forms',
            'landlord.admin.form.builder.contact' => 'contact form index',
            'landlord.admin.topbar.settings' => 'topbar settings',
            'landlord.admin.menu' => 'menu builder',
            'landlord.admin.all.user' => 'all user',
            'landlord.admin.new.user' => 'new user',
            'landlord.admin.all.admin.role' => 'all admin role',
            'landlord.admin.role.new' => 'new admin role index',
            'landlord.admin.tenant' => 'all tenants',
            'landlord.admin.tenant.all' => 'all tenants list',
            'landlord.admin.tenant.all' => 'all shops',
            'landlord.admin.tenant.new' => 'new tenant',
            'landlord.admin.tenant.settings' => 'account settings',
            'landlord.admin.tenant.failed.index' => 'failed tenants',
            'landlord.admin.package.order.manage.all' => 'all orders',
            'landlord.admin.package.order.success.page' => 'order success payment',
            'landlord.admin.package.order.cancel.page' => 'order cancel payment',
            'landlord.admin.package.order.page' => 'order page',
            'landlord.admin.package.order.report' => 'order report',
            'landlord.admin.payment.logs' => 'all payment logs',
            'landlord.admin.payment.report' => 'payment report',
            'landlord.admin.invoice.settings' => 'invoice settings',
            'landlord.admin.custom.domain.requests.all.pending' => 'all pending custom domain requests',
            'landlord.admin.custom.domain.requests.all' => 'all custom domain requests',
            'landlord.admin.custom.domain.requests.settings' => 'custom domain settings',
            'landlord.admin.general.basic.settings' => 'basic settings',
            'landlord.admin.general.page.settings' => 'page settings',
            'landlord.admin.general.site.identity' => 'site identity',
            'landlord.admin.general.color.settings' => 'color settings',
            'landlord.admin.general.typography.settings' => 'typography settings',
            'landlord.admin.general.seo.settings' => 'seo settings',
            'landlord.admin.general.gdpr.settings' => 'gdpr settings',
            'landlord.admin.general.payment.settings' => 'payment settings',
            'landlord.admin.general.third.party.script.settings' => 'third party script settings',
            'landlord.admin.general.smtp.settings' => 'smtp settings',
            'landlord.admin.general.ssl.settings' => 'ssl settings',
            'landlord.admin.general.custom.css.settings' => 'custom css settings',
            'landlord.admin.general.custom.js.settings' => 'custom js settings',
            'landlord.admin.general.database.upgrade.settings' => 'database upgrade',
            'landlord.admin.general.cache.settings' => 'cache settings',
            'landlord.admin.general.license.settings' => 'license settings',
            'landlord.admin.general.software.update.settings' => 'software update check settings',
            'landlord.admin.payment.settings.paypal' => 'paypal settings',
            'landlord.admin.payment.settings.paytm' => 'paytm settings',
            'landlord.admin.payment.settings.stripe' => 'stripe settings',
            'landlord.admin.payment.settings.razorpay' => 'razorpay settings',
            'landlord.admin.payment.settings.paystack' => 'paystack settings',
            'landlord.admin.payment.settings.mollie' => 'mollie settings',
            'landlord.admin.payment.settings.midtrans' => 'midtrans settings',
            'landlord.admin.payment.settings.cashfree' => 'cashfree settings',
            'landlord.admin.payment.settings.instamojo' => 'instamojo settings',
            'landlord.admin.payment.settings.marcadopago' => 'marcadopago settings',
            'landlord.admin.payment.settings.zitopay' => 'zitopay settings',
            'landlord.admin.payment.settings.squareup' => 'squareup settings',
            'landlord.admin.payment.settings.cinetpay' => 'cinetpay settings',
            'landlord.admin.payment.settings.paytabs' => 'paytabs settings',
            'landlord.admin.payment.settings.billplz' => 'billplz settings',
            'landlord.admin.payment.settings.toyyibpay' => 'toyyibpay settings',
            'landlord.admin.payment.settings.flutterwave' => 'flutterwave settings',
            'landlord.admin.payment.settings.payfast' => 'payfast settings',
            'landlord.admin.payment.settings.manual_payment' => 'manual payment settings',
            'landlord.admin.payment.settings.cod' => 'cod settings',
            'landlord.admin.languages' => 'languages',
            'landlord.admin.404.page.settings' => 'error 404 page settings',
            'landlord.admin.maintains.page.settings' => 'maintenance page settings',
            'landlord.admin.blog' => 'all blogs',
            'landlord.admin.blog.new' => 'new blog',
            'landlord.admin.blog.settings' => 'blog settings',
            'landlord.admin.blog.category' => 'blog category',
            'landlord.admin.coupon' => 'coupon manage',
            'landlord.plugin.manage.all' => 'plugins management',
        ];

        $pluginRoutes = (new ModuleMetaData())->getLandlordValidPluginsRouteList();

        return array_merge($generalRoutes, $pluginRoutes);
    }

    public static function tenantAdminRoutes():  array
    {
        $generalRoutes = [
            'tenant.admin.edit.profile' => 'Edit Profile',
            'tenant.admin.change.password' => 'Change Password',
            'tenant.admin.languages' => 'Languages',
            'tenant.admin.topbar.settings' => 'Topbar Settings',
            'tenant.admin.section.manage' => 'Section Title Manage',
            'tenant.admin.breadcrumb.manage' => 'Breadcrumb Manage',
            'tenant.admin.pages' => 'All Pages',
            'tenant.admin.pages.create' => 'Create Page',
            'tenant.admin.price.plan' => 'All Price Plan',
            'tenant.admin.price.plan.create' => 'Create Price Plan',
            'tenant.admin.testimonial' => 'Testimonials',
            'tenant.admin.blog' => 'Blog',
            'tenant.admin.blog.new' => 'New Blog',
            'tenant.admin.blog.settings' => 'Blog Settings',
            'tenant.admin.blog.category' => 'Blog Categories',
            'tenant.admin.blog.tag' => 'Blog Tags',
            'tenant.admin.form.builder.all' => 'All Custom Forms',
            'tenant.admin.menu' => 'Menu Manage',
            'tenant.admin.contact.message.all' => 'All Contact Messages',
            'tenant.admin.widgets' => 'Widgets',
            'tenant.admin.support.ticket.all' => 'All Support Tickets',
            'tenant.admin.support.ticket.new' => 'New Support Ticket',
            'tenant.admin.support.ticket.page.settings' => 'Support Ticket Page Settings',
            'tenant.admin.support.ticket.department' => 'Support Ticket Departments',
            'tenant.admin.other.settings' => 'Other Settings',
            'tenant.admin.user' => 'All Users',
            'tenant.admin.user.new' => 'New User',
            'tenant.admin.product.order.manage.all' => 'All Orders',
            'tenant.admin.product.order.success.page' => 'Order Success Page',
            'tenant.admin.product.order.cancel.page' => 'Order Cancel Page',
            'tenant.admin.product.order.page' => 'Order Page',
            'tenant.admin.payment.report' => 'Payment Report',
            'tenant.admin.general.page.settings' => 'General Page Settings',
            'tenant.admin.general.page.settings.home' => 'General Page Settings Home',
            'tenant.admin.general.basic.settings' => 'Basic Settings',
            'tenant.admin.general.site.identity' => 'Site Identity',
            'tenant.admin.general.color.settings' => 'Color Settings',
            'tenant.admin.general.typography.settings' => 'Typography Settings',
            'tenant.admin.general.seo.settings' => 'SEO Settings',
            'tenant.admin.general.third.party.script.settings' => 'Third Party Script Settings',
            'tenant.admin.general.email.settings' => 'Email Settings',
            'tenant.admin.general.gdpr.settings' => 'GDPR Settings',
            'tenant.admin.general.custom.css.settings' => 'Custom CSS Settings',
            'tenant.admin.general.custom.js.settings' => 'Custom JS Settings',
            'tenant.admin.general.cache.settings' => 'Cache Settings',
            'tenant.admin.general.license.settings' => 'License Settings',
            'tenant.admin.payment.settings.paypal' => 'Paypal Settings',
            'tenant.admin.payment.settings.paytm' => 'Paytm Settings',
            'tenant.admin.payment.settings.stripe' => 'Stripe Settings',
            'tenant.admin.payment.settings.razorpay' => 'Razorpay Settings',
            'tenant.admin.payment.settings.paystack' => 'Paystack Settings',
            'tenant.admin.payment.settings.mollie' => 'Mollie Settings',
            'tenant.admin.payment.settings.midtrans' => 'Midtrans Settings',
            'tenant.admin.payment.settings.cashfree' => 'Cashfree Settings',
            'tenant.admin.payment.settings.instamojo' => 'Instamojo Settings',
            'tenant.admin.payment.settings.marcadopago' => 'Marcadopago Settings',
            'tenant.admin.payment.settings.zitopay' => 'Zitopay Settings',
            'tenant.admin.payment.settings.squareup' => 'Squareup Settings',
            'tenant.admin.payment.settings.cinetpay' => 'Cinetpay Settings',
            'tenant.admin.payment.settings.paytabs' => 'Paytabs Settings',
            'tenant.admin.payment.settings.billplz' => 'Billplz Settings',
            'tenant.admin.payment.settings.toyyibpay' => 'Toyyibpay Settings',
            'tenant.admin.payment.settings.flutterwave' => 'Flutterwave Settings',
            'tenant.admin.payment.settings.payfast' => 'Payfast Settings',
            'tenant.admin.payment.settings.cod' => 'Cash On Delivery Settings',
            'tenant.admin.custom.domain.requests' => 'Custom Domain',
            'tenant.admin.country.all' => 'Country Manage',
            'tenant.admin.state.all' => 'State Manage',
            'tenant.admin.city.all' => 'City Manage',
            'tenant.admin.product.all' => 'All Products',
            'tenant.admin.product.create' => 'New Product',
            'tenant.admin.product.review' => 'Product Review',
            'tenant.admin.product.trash.all' => 'Trash Products',
            'tenant.admin.product.category.all' => 'All Product Category',
            'tenant.admin.product.subcategory.all' => 'All Product SubCategory',
            'tenant.admin.product.child-category.all' => 'All Product Child Category',
            'tenant.admin.product.colors.all' => 'All Product Color',
            'tenant.admin.product.colors.new' => 'New Product Color',
            'tenant.admin.product.sizes.all' => 'All Product Size',
            'tenant.admin.product.sizes.new' => 'New Product Size',
            'tenant.admin.settings.import.csv.settings' => 'Country, State and City from CSV',
            'tenant.admin.product.coupon.all' => 'Coupon Manage'
        ];

        $pluginRoutes = (new ModuleMetaData())->getTenantValidPluginsRouteList(exclude: ['cloud']);

        return array_merge($generalRoutes, $pluginRoutes);
    }
}
