<?php

namespace Plugins\WidgetBuilder\Widgets\Tenants\Electro;


use App\Facades\GlobalLanguage;
use App\Helpers\LanguageHelper;
use App\Models\Language;
use App\Models\Widgets;
use Modules\Blog\Entities\BlogCategory;
use Plugins\PageBuilder\Fields\Image;
use Plugins\PageBuilder\Fields\Number;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Fields\Select;
use Plugins\PageBuilder\Fields\Text;
use Plugins\PageBuilder\Fields\Textarea;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\WidgetBase;
use Mews\Purifier\Facades\Purifier;
use App\Helpers\SanitizeInput;

class AboutUsWidget extends WidgetBase
{
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();

        $output .= Image::get([
            'name' => 'logo_image',
            'label' => __('Logo'),
            'value' => $widget_saved_values['logo_image'] ?? null
        ]);

        $output .= Textarea::get([
            'name' => 'description',
            'label' => __('Description'),
            'value' => $widget_saved_values['description'] ?? null
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }

    public function frontend_render()
    {
        $widget_saved_values = $this->get_settings();
        $description = esc_html($widget_saved_values['description']) ?? '';
        $description = !empty($description) ? '<p class="footer-para mt-3">'.$description.'</p>' : '';
        $logo_image = $widget_saved_values['logo_image'];

        $root_url = url('/');

        $logo = render_image_markup_by_attachment_id($logo_image) ?? null;

        return <<<HTML
                    <div class="col-lg-4 col-sm-6 margin-top-30">
                        <div class="footer-widget widget color-four">
                            <div class="footer-inner text-center">
                                <div class="footer-logo">
                                    <a href="{$root_url}">
                                        {$logo}
                                    </a>
                                </div>
                                {$description}
                            </div>
                        </div>
                    </div>
HTML;
    }

    public function widget_title()
    {
        return __('Tenant About Us: Electro');
    }

    public function enable(): bool
    {
        return !is_null(tenant()); // TODO: Change the autogenerated stub
    }
}
